/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.ui;

import dev.architectury.platform.Platform;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;

public class KubeJSUIOptions {
    private static KubeJSUIOptions instance;
    public boolean useShaders;

    public static KubeJSUIOptions getInstance() {
        if (instance == null) {
            instance = new KubeJSUIOptions();
            HashMap<String, String> map = new HashMap<String, String>();
            boolean loaded = false;
            try {
                Path file = Platform.getGameFolder().resolve("optionskubejsui.txt");
                if (Files.exists(file, new LinkOption[0])) {
                    for (String s : Files.readAllLines(file)) {
                        String[] s1 = s.trim().split(":", 2);
                        if (s1.length != 2) continue;
                        map.put(s1[0].trim(), s1[1].trim());
                    }
                    loaded = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            KubeJSUIOptions.instance.useShaders = map.getOrDefault("useShaders", "true").equals("true");
            if (!loaded) {
                instance.save();
            }
        }
        return instance;
    }

    public void save() {
        Path file = Platform.getGameFolder().resolve("optionskubejsui.txt");
        try (PrintWriter printwriter = new PrintWriter(Files.newBufferedWriter(file, new OpenOption[0]));){
            printwriter.println("useShaders: " + this.useShaders);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

